<div class="front_page_section front_page_section_contacts<?php
	$eventicity_scheme = eventicity_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $eventicity_scheme ) && ! eventicity_is_inherit( $eventicity_scheme ) ) {
		echo ' scheme_' . esc_attr( $eventicity_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( eventicity_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( eventicity_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$eventicity_css      = '';
		$eventicity_bg_image = eventicity_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $eventicity_bg_image ) ) {
			$eventicity_css .= 'background-image: url(' . esc_url( eventicity_get_attachment_url( $eventicity_bg_image ) ) . ');';
		}
		if ( ! empty( $eventicity_css ) ) {
			echo ' style="' . esc_attr( $eventicity_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$eventicity_anchor_icon = eventicity_get_theme_option( 'front_page_contacts_anchor_icon' );
	$eventicity_anchor_text = eventicity_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $eventicity_anchor_icon ) || ! empty( $eventicity_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $eventicity_anchor_icon ) ? ' icon="' . esc_attr( $eventicity_anchor_icon ) . '"' : '' )
									. ( ! empty( $eventicity_anchor_text ) ? ' title="' . esc_attr( $eventicity_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( eventicity_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' eventicity-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$eventicity_css      = '';
			$eventicity_bg_mask  = eventicity_get_theme_option( 'front_page_contacts_bg_mask' );
			$eventicity_bg_color_type = eventicity_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_scheme_color( 'bg_color', $eventicity_scheme );
			} else {
				$eventicity_bg_color = '';
			}
			if ( ! empty( $eventicity_bg_color ) && $eventicity_bg_mask > 0 ) {
				$eventicity_css .= 'background-color: ' . esc_attr(
					1 == $eventicity_bg_mask ? $eventicity_bg_color : eventicity_hex2rgba( $eventicity_bg_color, $eventicity_bg_mask )
				) . ';';
			}
			if ( ! empty( $eventicity_css ) ) {
				echo ' style="' . esc_attr( $eventicity_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$eventicity_caption     = eventicity_get_theme_option( 'front_page_contacts_caption' );
			$eventicity_description = eventicity_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $eventicity_caption ) || ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $eventicity_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $eventicity_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $eventicity_caption, 'eventicity_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $eventicity_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $eventicity_description ), 'eventicity_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$eventicity_content = eventicity_get_theme_option( 'front_page_contacts_content' );
			$eventicity_layout  = eventicity_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $eventicity_layout && ( ! empty( $eventicity_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $eventicity_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $eventicity_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $eventicity_content, 'eventicity_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $eventicity_layout && ( ! empty( $eventicity_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$eventicity_sc = eventicity_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $eventicity_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $eventicity_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					eventicity_show_layout( do_shortcode( $eventicity_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $eventicity_layout && ( ! empty( $eventicity_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
