<?php
/**
 * The Header: Logo and main menu
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( eventicity_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'eventicity_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'eventicity_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('eventicity_action_body_wrap_attributes'); ?>>

		<?php do_action( 'eventicity_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'eventicity_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('eventicity_action_page_wrap_attributes'); ?>>

			<?php do_action( 'eventicity_action_page_wrap_start' ); ?>

			<?php
			$eventicity_full_post_loading = ( eventicity_is_singular( 'post' ) || eventicity_is_singular( 'attachment' ) ) && eventicity_get_value_gp( 'action' ) == 'full_post_loading';
			$eventicity_prev_post_loading = ( eventicity_is_singular( 'post' ) || eventicity_is_singular( 'attachment' ) ) && eventicity_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $eventicity_full_post_loading && ! $eventicity_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="eventicity_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'eventicity_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'eventicity' ); ?></a>
				<?php if ( eventicity_sidebar_present() ) { ?>
				<a class="eventicity_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'eventicity_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'eventicity' ); ?></a>
				<?php } ?>
				<a class="eventicity_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'eventicity_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'eventicity' ); ?></a>

				<?php
				do_action( 'eventicity_action_before_header' );

				// Header
				$eventicity_header_type = eventicity_get_theme_option( 'header_type' );
				if ( 'custom' == $eventicity_header_type && ! eventicity_is_layouts_available() ) {
					$eventicity_header_type = 'default';
				}
				get_template_part( apply_filters( 'eventicity_filter_get_template_part', "templates/header-" . sanitize_file_name( $eventicity_header_type ) ) );

				// Side menu
				if ( in_array( eventicity_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'eventicity_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'eventicity_action_after_header' );

			}
			?>

			<?php do_action( 'eventicity_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( eventicity_is_off( eventicity_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $eventicity_header_type ) ) {
						$eventicity_header_type = eventicity_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $eventicity_header_type && eventicity_is_layouts_available() ) {
						$eventicity_header_id = eventicity_get_custom_header_id();
						if ( $eventicity_header_id > 0 ) {
							$eventicity_header_meta = eventicity_get_custom_layout_meta( $eventicity_header_id );
							if ( ! empty( $eventicity_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$eventicity_footer_type = eventicity_get_theme_option( 'footer_type' );
					if ( 'custom' == $eventicity_footer_type && eventicity_is_layouts_available() ) {
						$eventicity_footer_id = eventicity_get_custom_footer_id();
						if ( $eventicity_footer_id ) {
							$eventicity_footer_meta = eventicity_get_custom_layout_meta( $eventicity_footer_id );
							if ( ! empty( $eventicity_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'eventicity_action_page_content_wrap_class', $eventicity_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'eventicity_filter_is_prev_post_loading', $eventicity_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( eventicity_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'eventicity_action_page_content_wrap_data', $eventicity_prev_post_loading );
			?>>
				<?php
				do_action( 'eventicity_action_page_content_wrap', $eventicity_full_post_loading || $eventicity_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'eventicity_filter_single_post_header', eventicity_is_singular( 'post' ) || eventicity_is_singular( 'attachment' ) ) ) {
					if ( $eventicity_prev_post_loading ) {
						if ( eventicity_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'eventicity_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$eventicity_path = apply_filters( 'eventicity_filter_get_template_part', 'templates/single-styles/' . eventicity_get_theme_option( 'single_style' ) );
					if ( eventicity_get_file_dir( $eventicity_path . '.php' ) != '' ) {
						get_template_part( $eventicity_path );
					}
				}

				// Widgets area above page
				$eventicity_body_style   = eventicity_get_theme_option( 'body_style' );
				$eventicity_widgets_name = eventicity_get_theme_option( 'widgets_above_page', 'hide' );
				$eventicity_show_widgets = ! eventicity_is_off( $eventicity_widgets_name ) && is_active_sidebar( $eventicity_widgets_name );
				if ( $eventicity_show_widgets ) {
					if ( 'fullscreen' != $eventicity_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					eventicity_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $eventicity_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'eventicity_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $eventicity_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'eventicity_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'eventicity_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="eventicity_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( eventicity_is_singular( 'post' ) || eventicity_is_singular( 'attachment' ) )
							&& $eventicity_prev_post_loading 
							&& eventicity_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'eventicity_action_between_posts' );
						}

						// Widgets area above content
						eventicity_create_widgets_area( 'widgets_above_content' );

						do_action( 'eventicity_action_page_content_start_text' );
