<?php
/**
 * Required plugins
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$eventicity_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'eventicity' ),
	'page_builders' => esc_html__( 'Page Builders', 'eventicity' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'eventicity' ),
	'socials'       => esc_html__( 'Socials and Communities', 'eventicity' ),
	'events'        => esc_html__( 'Events and Appointments', 'eventicity' ),
	'content'       => esc_html__( 'Content', 'eventicity' ),
	'other'         => esc_html__( 'Other', 'eventicity' ),
);
$eventicity_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'eventicity' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'eventicity' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $eventicity_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'eventicity' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'eventicity' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $eventicity_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'eventicity' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'eventicity' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $eventicity_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'eventicity' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'eventicity' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $eventicity_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'eventicity' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'eventicity' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $eventicity_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'eventicity' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'eventicity' ),
		'required'    => false,
		'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
		'logo'        => 'elegro-payment.png',
		'group'       => $eventicity_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'eventicity' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'eventicity' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $eventicity_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'eventicity' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'eventicity' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $eventicity_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $eventicity_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'eventicity' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $eventicity_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $eventicity_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'eventicity' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'eventicity' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => eventicity_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $eventicity_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'logo'        => eventicity_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => eventicity_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'logo'        => eventicity_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $eventicity_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => eventicity_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $eventicity_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => eventicity_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'eventicity' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'eventicity' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'eventicity' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $eventicity_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'eventicity' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'eventicity' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $eventicity_theme_required_plugins_groups['other'],
	),
	'gdpr-framework'         => array(
		'title'       => esc_html__( 'The GDPR Framework', 'eventicity' ),
		'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'eventicity' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'gdpr-framework.png',
		'group'       => $eventicity_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'eventicity' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'eventicity' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $eventicity_theme_required_plugins_groups['other'],
	),
);

if ( EVENTICITY_THEME_FREE ) {
	unset( $eventicity_theme_required_plugins['js_composer'] );
	unset( $eventicity_theme_required_plugins['booked'] );
	unset( $eventicity_theme_required_plugins['quickcal'] );
	unset( $eventicity_theme_required_plugins['the-events-calendar'] );
	unset( $eventicity_theme_required_plugins['calculated-fields-form'] );
	unset( $eventicity_theme_required_plugins['essential-grid'] );
	unset( $eventicity_theme_required_plugins['revslider'] );
	unset( $eventicity_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $eventicity_theme_required_plugins['trx_updater'] );
	unset( $eventicity_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
eventicity_storage_set( 'required_plugins', $eventicity_theme_required_plugins );
