<?php
/**
 * The template to display Admin notices
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.1
 */

$eventicity_theme_slug = get_option( 'template' );
$eventicity_theme_obj  = wp_get_theme( $eventicity_theme_slug );
?>
<div class="eventicity_admin_notice eventicity_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$eventicity_theme_img = eventicity_get_file_url( 'screenshot.jpg' );
	if ( '' != $eventicity_theme_img ) {
		?>
		<div class="eventicity_notice_image"><img src="<?php echo esc_url( $eventicity_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'eventicity' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="eventicity_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'eventicity' ),
				$eventicity_theme_obj->get( 'Name' ) . ( EVENTICITY_THEME_FREE ? ' ' . __( 'Free', 'eventicity' ) : '' ),
				$eventicity_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="eventicity_notice_text">
		<p class="eventicity_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $eventicity_theme_obj->description ) );
			?>
		</p>
		<p class="eventicity_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'eventicity' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="eventicity_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=eventicity_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'eventicity' );
			?>
		</a>
	</div>
</div>
