<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.71.0
 */

$eventicity_template_args = get_query_var( 'eventicity_template_args' );
if ( ! is_array( $eventicity_template_args ) ) {
	$eventicity_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$eventicity_columns       = 1;

$eventicity_expanded      = ! eventicity_sidebar_present() && eventicity_get_theme_option( 'expand_content' ) == 'expand';

$eventicity_post_format   = get_post_format();
$eventicity_post_format   = empty( $eventicity_post_format ) ? 'standard' : str_replace( 'post-format-', '', $eventicity_post_format );

if ( is_array( $eventicity_template_args ) ) {
	$eventicity_columns    = empty( $eventicity_template_args['columns'] ) ? 1 : max( 1, $eventicity_template_args['columns'] );
	$eventicity_blog_style = array( $eventicity_template_args['type'], $eventicity_columns );
	if ( ! empty( $eventicity_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $eventicity_columns > 1 ) {
	    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns, ! empty( $eventicity_template_args['columns_tablet']) ? $eventicity_template_args['columns_tablet'] : '', ! empty($eventicity_template_args['columns_mobile']) ? $eventicity_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $eventicity_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $eventicity_post_format ) );
	eventicity_add_blog_animation( $eventicity_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$eventicity_hover      = ! empty( $eventicity_template_args['hover'] ) && ! eventicity_is_inherit( $eventicity_template_args['hover'] )
							? $eventicity_template_args['hover']
							: eventicity_get_theme_option( 'image_hover' );
	$eventicity_components = ! empty( $eventicity_template_args['meta_parts'] )
							? ( is_array( $eventicity_template_args['meta_parts'] )
								? $eventicity_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $eventicity_template_args['meta_parts'] ) )
								)
							: eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) );
	eventicity_show_post_featured( apply_filters( 'eventicity_filter_args_featured',
		array(
			'no_links'   => ! empty( $eventicity_template_args['no_links'] ),
			'hover'      => $eventicity_hover,
			'meta_parts' => $eventicity_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $eventicity_template_args['thumb_size'] )
								? $eventicity_template_args['thumb_size']
								: eventicity_get_thumb_size( 
								in_array( $eventicity_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $eventicity_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$eventicity_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$eventicity_show_title = get_the_title() != '';
		$eventicity_show_meta  = count( $eventicity_components ) > 0 && ! in_array( $eventicity_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $eventicity_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'eventicity_filter_show_blog_categories', $eventicity_show_meta && in_array( 'categories', $eventicity_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'eventicity_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						eventicity_show_post_meta( apply_filters(
															'eventicity_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $eventicity_hover, 1
															)
											);
						?>
					</div>
					<?php
					$eventicity_components = eventicity_array_delete_by_value( $eventicity_components, 'categories' );
					do_action( 'eventicity_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'eventicity_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'eventicity_action_before_post_title' );
					if ( empty( $eventicity_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'eventicity_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $eventicity_template_args['excerpt_length'] ) && ! in_array( $eventicity_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$eventicity_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'eventicity_filter_show_blog_excerpt', empty( $eventicity_template_args['hide_excerpt'] ) && eventicity_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				eventicity_show_post_content( $eventicity_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'eventicity_filter_show_blog_meta', $eventicity_show_meta, $eventicity_components, 'band' ) ) {
			if ( count( $eventicity_components ) > 0 ) {
				do_action( 'eventicity_action_before_post_meta' );
				eventicity_show_post_meta(
					apply_filters(
						'eventicity_filter_post_meta_args', array(
							'components' => join( ',', $eventicity_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'eventicity_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'eventicity_filter_show_blog_readmore', ! $eventicity_show_title || ! empty( $eventicity_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $eventicity_template_args['no_links'] ) ) {
				do_action( 'eventicity_action_before_post_readmore' );
				eventicity_show_post_more_link( $eventicity_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'eventicity_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $eventicity_template_args ) ) {
	if ( ! empty( $eventicity_template_args['slider'] ) || $eventicity_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
