<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$eventicity_copyright_scheme = eventicity_get_theme_option( 'copyright_scheme' );
if ( ! empty( $eventicity_copyright_scheme ) && ! eventicity_is_inherit( $eventicity_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $eventicity_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$eventicity_copyright = eventicity_get_theme_option( 'copyright' );
			if ( ! empty( $eventicity_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$eventicity_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $eventicity_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$eventicity_copyright = eventicity_prepare_macros( $eventicity_copyright );
				// Display copyright
				echo wp_kses( nl2br( $eventicity_copyright ), 'eventicity_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
