<?php
/**
 * The template to display default site footer
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.10
 */

$eventicity_footer_id = eventicity_get_custom_footer_id();
$eventicity_footer_meta = get_post_meta( $eventicity_footer_id, 'trx_addons_options', true );
if ( ! empty( $eventicity_footer_meta['margin'] ) ) {
	eventicity_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( eventicity_prepare_css_value( $eventicity_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $eventicity_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $eventicity_footer_id ) ) ); ?>
						<?php
						$eventicity_footer_scheme = eventicity_get_theme_option( 'footer_scheme' );
						if ( ! empty( $eventicity_footer_scheme ) && ! eventicity_is_inherit( $eventicity_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $eventicity_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'eventicity_action_show_layout', $eventicity_footer_id );
	?>
</footer><!-- /.footer_wrap -->
