<?php
/**
 * The template to display Admin notices
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.64
 */

$eventicity_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$eventicity_skins_args = get_query_var( 'eventicity_skins_notice_args' );
?>
<div class="eventicity_admin_notice eventicity_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$eventicity_theme_img = eventicity_get_file_url( 'screenshot.jpg' );
	if ( '' != $eventicity_theme_img ) {
		?>
		<div class="eventicity_notice_image"><img src="<?php echo esc_url( $eventicity_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'eventicity' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="eventicity_notice_title">
		<?php esc_html_e( 'New skins are available', 'eventicity' ); ?>
	</h3>
	<?php

	// Description
	$eventicity_total      = $eventicity_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$eventicity_skins_msg  = $eventicity_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $eventicity_total, 'eventicity' ), $eventicity_total ) . '</strong>'
							: '';
	$eventicity_total      = $eventicity_skins_args['free'];
	$eventicity_skins_msg .= $eventicity_total > 0
							? ( ! empty( $eventicity_skins_msg ) ? ' ' . esc_html__( 'and', 'eventicity' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $eventicity_total, 'eventicity' ), $eventicity_total ) . '</strong>'
							: '';
	$eventicity_total      = $eventicity_skins_args['pay'];
	$eventicity_skins_msg .= $eventicity_skins_args['pay'] > 0
							? ( ! empty( $eventicity_skins_msg ) ? ' ' . esc_html__( 'and', 'eventicity' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $eventicity_total, 'eventicity' ), $eventicity_total ) . '</strong>'
							: '';
	?>
	<div class="eventicity_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'eventicity' ), $eventicity_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="eventicity_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $eventicity_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'eventicity' );
			?>
		</a>
	</div>
</div>
