<?php
/**
 * The template to display the site logo in the footer
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.10
 */

// Logo
if ( eventicity_is_on( eventicity_get_theme_option( 'logo_in_footer' ) ) ) {
	$eventicity_logo_image = eventicity_get_logo_image( 'footer' );
	$eventicity_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $eventicity_logo_image['logo'] ) || ! empty( $eventicity_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $eventicity_logo_image['logo'] ) ) {
					$eventicity_attr = eventicity_getimagesize( $eventicity_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $eventicity_logo_image['logo'] ) . '"'
								. ( ! empty( $eventicity_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $eventicity_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'eventicity' ) . '"'
								. ( ! empty( $eventicity_attr[3] ) ? ' ' . wp_kses_data( $eventicity_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $eventicity_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $eventicity_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
