<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.10
 */

// Footer sidebar
$eventicity_footer_name    = eventicity_get_theme_option( 'footer_widgets' );
$eventicity_footer_present = ! eventicity_is_off( $eventicity_footer_name ) && is_active_sidebar( $eventicity_footer_name );
if ( $eventicity_footer_present ) {
	eventicity_storage_set( 'current_sidebar', 'footer' );
	$eventicity_footer_wide = eventicity_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $eventicity_footer_name ) ) {
		dynamic_sidebar( $eventicity_footer_name );
	}
	$eventicity_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $eventicity_out ) ) {
		$eventicity_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $eventicity_out );
		$eventicity_need_columns = true;   //or check: strpos($eventicity_out, 'columns_wrap')===false;
		if ( $eventicity_need_columns ) {
			$eventicity_columns = max( 0, (int) eventicity_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $eventicity_columns ) {
				$eventicity_columns = min( 4, max( 1, eventicity_tags_count( $eventicity_out, 'aside' ) ) );
			}
			if ( $eventicity_columns > 1 ) {
				$eventicity_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $eventicity_columns ) . ' widget', $eventicity_out );
			} else {
				$eventicity_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $eventicity_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'eventicity_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $eventicity_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $eventicity_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'eventicity_action_before_sidebar', 'footer' );
				eventicity_show_layout( $eventicity_out );
				do_action( 'eventicity_action_after_sidebar', 'footer' );
				if ( $eventicity_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $eventicity_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'eventicity_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
