<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

// Page (category, tag, archive, author) title

if ( eventicity_need_page_title() ) {
	eventicity_sc_layouts_showed( 'title', true );
	eventicity_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								eventicity_show_post_meta(
									apply_filters(
										'eventicity_filter_post_meta_args', array(
											'components' => join( ',', eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'counters' ) ) ),
											'seo'        => eventicity_is_on( eventicity_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$eventicity_blog_title           = eventicity_get_blog_title();
							$eventicity_blog_title_text      = '';
							$eventicity_blog_title_class     = '';
							$eventicity_blog_title_link      = '';
							$eventicity_blog_title_link_text = '';
							if ( is_array( $eventicity_blog_title ) ) {
								$eventicity_blog_title_text      = $eventicity_blog_title['text'];
								$eventicity_blog_title_class     = ! empty( $eventicity_blog_title['class'] ) ? ' ' . $eventicity_blog_title['class'] : '';
								$eventicity_blog_title_link      = ! empty( $eventicity_blog_title['link'] ) ? $eventicity_blog_title['link'] : '';
								$eventicity_blog_title_link_text = ! empty( $eventicity_blog_title['link_text'] ) ? $eventicity_blog_title['link_text'] : '';
							} else {
								$eventicity_blog_title_text = $eventicity_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $eventicity_blog_title_class ); ?>">
								<?php
								$eventicity_top_icon = eventicity_get_term_image_small();
								if ( ! empty( $eventicity_top_icon ) ) {
									$eventicity_attr = eventicity_getimagesize( $eventicity_top_icon );
									?>
									<img src="<?php echo esc_url( $eventicity_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'eventicity' ); ?>"
										<?php
										if ( ! empty( $eventicity_attr[3] ) ) {
											eventicity_show_layout( $eventicity_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $eventicity_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $eventicity_blog_title_link ) && ! empty( $eventicity_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $eventicity_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $eventicity_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'eventicity_action_breadcrumbs' );
						$eventicity_breadcrumbs = ob_get_contents();
						ob_end_clean();
						eventicity_show_layout( $eventicity_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
